/*
 * File: auth.h
 *
 * Bare SMTP client
 *
 * Authorisation type codes and table
 *
 * Bob Eager   May 2016
 *
 */

/* Internal authorisation mechanism codes. Note that the numeric order is
   significant; if the server offers more than one mechanism that is supported
   by this client, then the lowest numbered one is chosen. */

#define	AUTH_NONE	0
#define	AUTH_PLAIN	1
#define	AUTH_LOGIN	2
#define	AUTH_CRAM_MD5	3

/* Mechanism type table */

typedef	struct	_AUTHTYPE {
	PCHAR	authname;		/* Authorisation mechanism name */
	INT	authcode;		/* Authorisation mechanism code */
} AUTHTYPE, *PAUTHTYPE;

static AUTHTYPE authtab[] = {
	{ "PLAIN", AUTH_PLAIN },
	{ "LOGIN", AUTH_LOGIN },
	{ "CRAM-MD5", AUTH_CRAM_MD5 },
	{ "",      AUTH_NONE }			/* End of table marker */
};

/*
 * End of file: auth.h
 *
 */
