/*
 * File: md5.h
 *
 * MD5 implementation; header file
 *
 * Bob Eager   May 2016
 *
 */

#define	DIGEST_SIZE	16

/* MD5 context */

typedef struct MD5Context {
UINT	state[4];	/* state (ABCD) */
UINT	count[2];	/* number of bits, modulo 2^64 (lsb first) */
CHAR	buffer[64];	/* input buffer */
} MD5_CTX, *PMD5_CTX;

extern	VOID	hmac_md5(PCHAR, INT, PCHAR, INT, PCHAR);
extern	VOID	MD5Init(PMD5_CTX);
extern	VOID	MD5Update(PMD5_CTX, const PCHAR, UINT);
extern	VOID	MD5Final(CHAR[DIGEST_SIZE], PMD5_CTX);

/*
 * End of file: md5.h
 *
 */
