/*
 * File: netio.h
 *
 * General network I/O and timeout routines; header file.
 *
 * Bob Eager   May 2016
 *
 */

#include "typedefs.h"

/* Error codes */

#define	SOCKIO_TOOLONG		-1	/* Line too long from sock_gets() */
#define	SOCKIO_TIMEOUT		-2	/* Timeout on sock_gets()/sock_puts() */
#define	SOCKIO_ERR		-3	/* Nonspecific socket I/O error */

/* Network I/O functions */

extern	BOOL	netio_init(VOID);
extern	INT	sock_gets(PCHAR, INT, INT, INT);
extern	VOID	sock_puts(PCHAR, INT, INT);

/*
 * End of file: netio.h
 *
 */

