/*
 * File: smtp.h
 *
 * Bare SMTP client for Tavi network
 *
 * Header file
 *
 * Bob Eager   May 2016
 *
 */

#include <syslog.h>

#include "typedefs.h"
#include "log.h"

#define	VERSION			5	/* Major version number */
#define	EDIT			2	/* Edit number within major version */

#define	FALSE			0
#define	TRUE			1

#define	MAXFILENAME		200	/* Max length of message file name */
#define	MAXUNAME		50	/* Maximum length of username */
#define	MAXPASS			64	/* Maximum length of password */

/* Structure definitions */

typedef struct _FL {			/* Filename list cell */
struct	_FL	*next;
INT		isdir;
PCHAR		name;
} FL, *PFL;

/* External references */

extern	VOID	error(PCHAR mes, ...);
extern	BOOL	client(INT, PFL, PCHAR, BOOL, PCHAR, PCHAR, PCHAR);
extern	BOOL	something(PFL);
extern	PVOID	xmalloc(size_t);

/*
 * End of file: smtp.h
 *
 */

