/*
 * File beu.h
 *
 * Book entry utility
 *
 * Header file
 *
 * Bob Eager   May 2010
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>

#include <sys/time.h>
#include <unistd.h>

#include <curses.h>

#include "typedefs.h"

#define	VERSION			1	/* Major version number */
#define	EDIT			1	/* Edit number within major version */

#define	FALSE			0
#define	TRUE			1

#define	ISBNSIZE		13	/* Handles 10 and 13 digit values */
#define	SHELF_LENGTH		4	/* Length of bookshelf value */
#define	MAXTITLE		100	/* Maximum title length */
#define	MAXAUTHOR		100	/* Maximum author length */
#define	MAXLINE			250	/* Size of line buffer */
#define	MAXLOG			200	/* Size of log buffer */

#define	AUTHOR_UNKNOWN		"UNKNOWN"

/* Screen layout */

#define	WIDTH		80
#define	DEPTH		24

#define	FIELD_X		15		/* x position for fields start */
#define	MESSAGE_X	5		/* x position for message start */

#define	BANNER_Y	1		/* y position for screen banner */
#define	SHELF_Y		3		/* y position for shelf name */
#define	ISBN_Y		6		/* y position for ISBN field */
#define	TITLE_Y		8		/* y position for title field */
#define	AUTHOR_Y	10		/* y position for first author field */
#define	HELP_Y		(DEPTH-2)	/* y position for help line */
#define	MESSAGE_Y	(DEPTH-4)	/* y position for message line */

#define	ISBN_LENGTH	ISBNSIZE+3	/* ISBN field length (allow for dashes) */
#define	TITLE_LENGTH	60		/* title field length */
#define	AUTHOR_LENGTH	40		/* author field length */
#define	MESSAGE_LENGTH	70		/* message area length */

#define	BANNER_ATTR	(A_BOLD)	/* banner attributes */
#define	SHELF_ATTR	(A_BOLD)	/* shelf attributes */
#define	FIELD_ATTR	(A_NORMAL)	/* input field attributes */
#define	INPUT_ATTR	(A_REVERSE)	/* current input field attributes */
#define	MESSAGE_ATTR	(A_BOLD)	/* message attributes */

#define	ISBN_LABEL	"ISBN"		/* field labels */
#define	TITLE_LABEL	"Title"
#define	AUTHOR_LABEL	"Author %d"

#define	ISBN_HELP_X	41		/* position of 'auto' help text */

#define	NAUTHORS	5		/* max number of authors */

#define	ACCEPT_DELAY	2		/* seconds after accept message */

/* Structure definitions */

typedef struct _CONFIG {		/* Configuration information */
PCHAR		countfile;		/* Location of count file */
} CONFIG, *PCONFIG;

typedef struct _BOOK {			/* Book data */
BOOL		valid;			/* Information is valid */
INT		nauthors;		/* Number of authors */
CHAR		isbn[ISBNSIZE+1];	/* ISBN */
CHAR		title[MAXTITLE+1];	/* Title */
CHAR		authors[NAUTHORS][MAXAUTHOR+1];/* Author list */
CHAR		shelf[SHELF_LENGTH+1];	/* Bookshelf code */
PWINDOW		w_isbn;			/* ISBN window */
PWINDOW		w_title;		/* Title window */
PWINDOW		w_authors[NAUTHORS];	/* Author windows */
PWINDOW		w_message;		/* Message window */
} BOOK, *PBOOK;

/* External references */

extern	BOOL	check_isbn(PCHAR, PCHAR, PBOOK);
extern	VOID	clear_message(PBOOK);
extern	VOID	draw_initial_screen(PBOOK);
extern	VOID	error(PCHAR, ...);
extern	VOID	fatal(PCHAR, PBOOK);
extern	BOOL	get_book(PCONFIG, PBOOK);
extern	VOID	index_final(VOID);
extern	BOOL	index_init(PCONFIG);
extern	ULONG	index_next(VOID);
extern	VOID	message(PCHAR, PBOOK);
extern	VOID	next_pseudo_isbn(PCHAR);
extern	INT	read_config(PCHAR, PCONFIG);

/*
 * End of file: beu.h
 *
 */
