/*
 * File: message.c
 *
 * Book entry utility
 *
 * Message handler
 *
 * Bob Eager   May 2010
 *
 */

#include "beu.h"


/*
 * Output a message on the message line.
 *
 *	Inputs:
 *		msg	pointer to message
 *		book	pointer to book structure
 *
 *	Outputs:
 *		none
 *
 */

VOID message(PCHAR msg, PBOOK book)
{	INT len = strlen(msg);
	CHAR temp[MESSAGE_LENGTH+1];

	if(len > MESSAGE_LENGTH-8) len = MESSAGE_LENGTH-8;
	strcpy(temp, "*** ");
	strncat(temp, msg, len);
	strcat(temp, " ***");

	clear_message(book);		/* in case new message is shorter */
	mvwaddstr(book->w_message, 0, 0, temp);
	touchwin(stdscr);
	refresh();
	beep();
}


/*
 * Clear the message line.
 *
 *	Inputs:
 *		book	pointer to book structure
 *
 *	Outputs:
 *		none
 *
 */

VOID clear_message(PBOOK book)
{	wclear(book->w_message);
	touchwin(stdscr);
	refresh();
}


/*
 * Output a fatal message on the message line.
 * This is displayed for MESSAGE_SLEEP seconds, and then the program
 * aborts.
 *
 *	Inputs:
 *		msg	pointer to message
 *		book	pointer to book structure
 *
 *	Outputs:
 *		none
 *
 */

VOID fatal(PCHAR msg, PBOOK book)
{	INT i;
	BOOL flag = FALSE;
	CHAR temp[MESSAGE_LENGTH+1];

	i = strlen(msg);
	if(i > MESSAGE_LENGTH) i = MESSAGE_LENGTH;
	memset(temp, '-', i);
	temp[i] = '\0';

	for(i = 0; i < 15; i++) {
		message(flag ? msg : temp, book);
		flag = !flag;
		beep();
		sleep(1);
	}

	erase(); refresh();		/* clear the screen */
	echo();				/* input echo back on */
	nl();				/* newline processing back on */
	nocbreak();			/* restore input mode */
	endwin();			/* restore screen */

	error(msg);			/* another copy after screen clear */
	abort();			/* give up */
}

/*
 * End of file: message.c
 *
 */
