/*
 * File: confcmds.h
 *
 * Book lookup utility
 *
 * Configuration command codes and table
 *
 * Bob Eager   April 2014
 *
 */

/* Internal command codes */

#define	CMD_DB_URL		1
#define	CMD_ACCESS_KEY		2
#define	CMD_CUECAT		3
#define	CMD_BAD			4

static	struct {
	PCHAR	cmdname;		/* Command name */
	INT	cmdcode;		/* Command code */
} cmdtab[] = {
	{ "DB_URL",		CMD_DB_URL },
	{ "ACCESS_KEY",		CMD_ACCESS_KEY },
	{ "CUECAT",		CMD_CUECAT },
	{ "",			CMD_BAD }	/* End of table marker */
};

/*
 * End of file: confcmds.h
 *
 */
