/*
 * File blu.h
 *
 * Book lookup utility
 *
 * Header file
 *
 * Bob Eager   April 2014
 *
 */

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <stdlib.h>
#include <limits.h>

#include <sys/socket.h>
#include <sys/time.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/nameser.h>
#include <arpa/inet.h>
#include <resolv.h>
#include <unistd.h>

#include "typedefs.h"

#define	VERSION			1	/* Major version number */
#define	EDIT			3	/* Edit number within major version */

#define	FALSE			0
#define	TRUE			1

#define	ISBNSIZE		13	/* Handles 10 and 13 digit values */
#define	BOOKSHELF_LENGTH	4	/* Length of bookshelf value */
#define	MAXTITLE		100	/* Maximum title length */
#define	MAXAUTHOR		100	/* Maximum author length */
#define	MAXAUTHORS		10	/* Max number of authors per book */
#define	MAXLINE			250	/* Size of line buffer */
#define	MAXLOG			200	/* Size of log buffer */

#define	HTTP_SCHEME		"http://"
#define	HTTPSERVICE		"http"	/* Name of HTTP service */
#define	TCP			"tcp"	/* TCP protocol */

#define	AUTHOR_UNKNOWN		"UNKNOWN"

typedef struct _CONFIG {		/* Configuration information */
PCHAR		access_key;		/* Access key string */
PCHAR		db_url;			/* URL for lookup service */
BOOL		cuecat;			/* CueCat mode */
} CONFIG, *PCONFIG;

typedef struct _BOOK {			/* Book data */
BOOL		verbose;		/* General verbosity */
BOOL		quiet;			/* No prompting */
BOOL		debug;			/* Debug flag */
BOOL		valid;			/* Information is valid */
INT		nauthors;		/* Number of authors */
CHAR		isbn[ISBNSIZE+1];	/* ISBN */
CHAR		title[MAXTITLE+1];	/* Title */
CHAR		authors[MAXAUTHORS][MAXAUTHOR+1];/* Author list */
CHAR		shelf[BOOKSHELF_LENGTH+1];/* Bookshelf code */
} BOOK, *PBOOK;

/* External references */

extern	PCHAR	cuecat_gets(PCHAR, INT, BOOL);
extern	VOID	dolog(PCHAR, ...);
extern	VOID	error(PCHAR, ...);
extern	VOID	extract_book(PCHAR, UINT, PBOOK);
extern	BOOL	get_isbn(PCHAR, PCONFIG, PBOOK);
extern	VOID	lookup_free(PCHAR);
extern	PCHAR	lookup_isbn(PCHAR, PCONFIG, PINT);
extern	INT	read_config(PCHAR, PCONFIG);
extern	VOID 	strlwr(PCHAR);

/*
 * End of file: blu.h
 *
 */
