/*
 * File: bwmon.h
 *
 * Bandwidth monitor
 *
 * Bob Eager   August 2016
 *
 */

#define	VERSION		1
#define	EDIT		4

#if 0
#define	HAVE_LIBPQ
#endif

#define	DEBUG(s,x) syslog(LOG_DEBUG, "[%c]: "s, config.tag, x);

#include <unistd.h>
#include <errno.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <net/ethernet.h>
#include <pcap.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <inttypes.h>
#include <gd.h>
#include <gdfonts.h>
#include <netdb.h>
#include <time.h>
#include <syslog.h>

/* Constants */

#define	MAX_HOSTNAME	255
#define	MAXPATH		200

#define	DNS_TIMEOUT	10		/* seconds */

#define	PROGNAME	"bwmon"
#define	PROGTITLE	"BWMon"
#define	CSS_FILE	PROGNAME".css"
#define	LEGEND_FILE	"legend.png"

#define	DEFAULT_CONFIG_FILE	"/usr/local/etc/"PROGNAME".conf"
#define	DEFAULT_HTDOCS	"/usr/local/etc/"PROGNAME"/htdocs/"
#define	DEFAULT_LOGS	"/var/log/"PROGNAME"/"
#define	DEFAULT_PIDFILE	"/var/run/"PROGNAME".pid"
#define DEFAULT_REFRESH	150
#define	DEFAULT_TOP	20

#define	MIN_TOP		2
#define	MAX_TOP		100

#define	CDF_FILE	"log.%c.%d.cdf"
#define	INDEX_HTML	"index.html"
#define	INDEX2_HTML	"index2.html"
#define	INDEX3_HTML	"index3.html"
#define	INDEX4_HTML	"index4.html"
#define	INDEXT_HTML	"index%c.html"
#define	SUBNET_HTML	"subnet-%c-%s.html"
#define	S_GRAPH		"%s-%c-S.png"
#define	R_GRAPH		"%s-%c-R.png"

#define	DEFAULT_MAXIPS	50		/* Maximum different IPs to record */
#define	MIN_MAXIPS	4
#define	MAX_MAXIPS	10000

#define	MAX_FTP_PORTS	50
#define	MAX_HTTP_PORTS	50
#define	MAX_P2P_PORTS	50
#define MAX_SUBNETS	50		/* number we can handle */

#define XWIDTH		900		/* graph dimensions and position */
#define YHEIGHT		256L
#define XOFFSET		90L
#define YOFFSET		45L

#define NR_WORKER_CHILDS 3		/* constant, but code depends on it */

#define RANGE1		172800.0	/* 2 days */
#define RANGE2		604800.0	/* 7 days */
#define RANGE3		3024000.0	/* 35 days */
#define RANGE4		35640000.0	/* 412.5ish days  */

#define INTERVAL1	200L		/* 3 mins 20 secs */
#define INTERVAL2	600L		/* 10 minutes */
#define INTERVAL3	3600L		/* 1 hour */
#define INTERVAL4	43200L		/* 12 hours */

#define DEFAULT_INTERVALS 1		/* No. of Intervals to wait before
					   redrawing the graphs */
#define DEFAULT_CUTOFF	1024*1024	/* If total data transfered doesn't
					   reach at least this number, we
					   don't graph the IP */

#define LEAD		.05		/* % of time to lead the graph */

#define DB_PGSQL	1
#define	DB_MYSQL	2

#define TRUE		1
#define FALSE		0

/* Type definitions */

typedef	void			VOID, *PVOID;
typedef	int			BOOL, *PBOOL;
typedef	int			INT, *PINT;
typedef	unsigned int		UINT, *PUINT;
typedef	unsigned short		USHORT, *PUSHORT;
typedef	long			LONG, *PLONG;
typedef	long long int		LONGLONG, *PLONGLONG;
typedef	unsigned long		ULONG, *PULONG;
typedef	unsigned long long	ULONGLONG, *PULONGLONG;
typedef	char			CHAR, *PCHAR;
typedef	unsigned char		UCHAR, *PUCHAR;
typedef	float			FLOAT, *PFLOAT;
typedef	double			DOUBLE, *PDOUBLE;

/* Structure definitions */

typedef struct _CONFIG {	/* Configuration settings */
PCHAR		dev;
PCHAR		htdocs;
PCHAR		logs;
PCHAR		pidfile;
PCHAR		filter;
UINT		skip_intervals;
ULONGLONG	graph_cutoff;
UINT		top;
BOOL		promisc;
BOOL		output_cdf;
BOOL		recover_cdf;
BOOL		graph;
DOUBLE		range;
ULONGLONG	interval;
CHAR		tag;
UINT		meta_refresh;
UINT		max_ips;
BOOL		output_database;
PCHAR		db_connect_string;
PCHAR		sensor_id;
} CONFIG, *PCONFIG;

typedef struct _SUBNETDATA {	/* Subnet being monitored */
UINT		ip;
UINT		mask;
} SUBNETDATA, *PSUBNETDATA;

typedef struct _STATISTICS {
ULONGLONG	total;
ULONGLONG	icmp;
ULONGLONG	udp;
ULONGLONG	tcp;
ULONGLONG	ftp;
ULONGLONG	http;
ULONGLONG	p2p;
} STATISTICS, *PSTATISTICS;

typedef struct _SUMMARYDATA {
UINT		ip;
BOOL		graph;  	/* TRUE if graph written for this IP */
ULONGLONG	total;
ULONGLONG	totalsent;
ULONGLONG	totalreceived;
ULONGLONG	icmp;
ULONGLONG	udp;
ULONGLONG	tcp;
ULONGLONG	ftp;
ULONGLONG	http;
ULONGLONG	p2p;
} SUMMARYDATA, *PSUMMARYDATA;

typedef struct _IPDATA {
time_t		timestamp;
UINT		ip;		/* Host byte order */
STATISTICS	send;
STATISTICS	receive;
} IPDATA, *PIPDATA;

#define IPDATAALLOCCHUNKS 100
typedef struct _DATASTOREBLOCK {
time_t		latesttimestamp;
INT		numentries;  /* Index of first unused entry in IPDATA block */
PIPDATA		data;  /* Allocated at creation, and thus always exist */
struct _DATASTOREBLOCK	*next;
} DATASTOREBLOCK, *PDATASTOREBLOCK;

typedef struct _IPDATASTORE {
UINT			ip;
PDATASTOREBLOCK		firstblock;  /* Allocated at the same time, so it always exists.*/
struct _IPDATASTORE	*next;
} IPDATASTORE, *PIPDATASTORE;

/* External variables */

extern	CONFIG		config;
extern	INT		ftp_ports;
extern	INT		ftp_port[];
extern	INT		http_ports;
extern	INT		http_port[];
extern	INT		p2p_ports;
extern	INT		p2p_port[];
extern	SUBNETDATA	subnet_table[];
extern	UINT		subnet_count;

/* External function prototypes */

extern	VOID	graph_ip(PIPDATASTORE, PSUMMARYDATA, time_t);
extern	PCHAR	hostip_to_charip(ULONG, PCHAR);
extern	VOID	make_index_pages(INT, PSUMMARYDATA []);
extern	VOID	webpage_head(FILE *, PCHAR, PCHAR);
extern	VOID	webpage_period_links(FILE *, CHAR);
extern	VOID	webpage_tail(FILE *);

/*
 * End of file: bwmon.h
 *
 */
