#!/bin/sh

# $FreeBSD$
#
# PROVIDE: bwmon
# REQUIRE: LOGIN
# KEYWORD: shutdown
#
# Add the following line to /etc/rc.conf or /etc/rc.conf.local
# to enable this service:
#
# bwmon_enable (bool):	Set to NO by default
#			Set to YES to enable bwmon
#

. /etc/rc.subr

desc="Network bandwidth monitor"
name=bwmon
rcvar=bwmon_enable

load_rc_config $name
eval "${rcvar}=\${${rcvar}:-'NO'}"
command="/usr/local/bin/${name}"

pidfile="/var/run/${name}.pid"
htdocs=/usr/local/etc/bwmon/htdocs
logs=/var/log/bwmon

required_files="/usr/local/etc/${name}.conf ${htdocs}/legend.png"
required_files="${required_files} ${htdocs}/${name}.css"
required_dirs=${logs}

sig_rotate=HUP
extra_commands=rotate
rotate_cmd=bwmon_rotate
restart_cmd=:

bwmon_rotate()
{
	if [ -e ${pidfile} ]
	then
		kill -${sig_rotate} `cat ${pidfile}`
	fi
}

run_rc_command "$1"
