%{
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "conf.tab.h"
%}

%%
[ \t]+			/* Ignore */;
\n			{ return TOKNEWLINE; }
#.*\n        		{ return TOKNEWLINE; }
([0-9]{1,3}"."){3,3}([0-9]{1,3}) { bmconf_lval.string=strdup(yytext); return IPADDR; }
[-0-9]+			{ bmconf_lval.number=atoi(yytext); return NUMBER; }
\".*\"			{ bmconf_lval.string=strdup(yytext); return STRING; }
\/			{ return TOKSLASH; }
true|false              { bmconf_lval.number=!strcmp(yytext,"true"); return STATE; }
subnet			{ return TOKSUBNET; }
device			{ return TOKDEV; }
htdocs			{ return TOKHTDOCS; }
pidfile			{ return TOKPIDFILE; }
logs			{ return TOKLOGS; }
skip_intervals		{ return TOKSKIPINTERVALS; }
top			{ return TOKTOP; }
graph_cutoff		{ return TOKGRAPHCUTOFF; }
promiscuous		{ return TOKPROMISC; }
output_cdf		{ return TOKOUTPUTCDF; }
recover_cdf		{ return TOKRECOVERCDF; }
graph			{ return TOKGRAPH; }
filter			{ return TOKFILTER; }
meta_refresh		{ return TOKMETAREFRESH; }
pgsql_connect_string	{ return TOKPGSQLCONNECTSTRING; }
mysql_connect_string	{ return TOKMYSQLCONNECTSTRING; }
sensor_id		{ return TOKSENSORID; }
ftp_ports		{ return TOKFTPPORTS; }
http_ports		{ return TOKHTTPPORTS; }
p2p_ports		{ return TOKP2PPORTS; }
max_ips			{ return TOKMAXIPS; }
.			{ return TOKJUNK; }
%%
