%{
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "bwmon.h"

int	bmconf_lex(void);
int	lineno = 1;

void bmconf_error(const char * str)
{	fprintf(stderr, PROGNAME": %s in config file on line %d\n",
		str, lineno);
	syslog(LOG_ERR, "%s in config file on line %d",
		str, lineno);
	exit(EXIT_FAILURE);
}

static void bmconf_dberror(void)
{	fprintf(stderr,
		PROGNAME": more than one database specified in config file"
		" on line %d\n", lineno);
		syslog(LOG_ERR,
			"more than one database specified in config file"
			"on line %d", lineno);
		exit(EXIT_FAILURE);
}

static void bmconf_subnet_error(void)
{	fprintf(stderr, PROGNAME": more than %d subnets defined\n", MAX_SUBNETS);
	syslog(LOG_ERR, "more than %d subnets defined\n", MAX_SUBNETS);
	exit(EXIT_FAILURE);
}

static void bmconf_port_error(char *type, int max)
{	fprintf(stderr, PROGNAME": more than %d %s ports defined\n", max, type);
	syslog(LOG_ERR, "more than %d %s ports defined\n", max, type);
	exit(EXIT_FAILURE);
}

int bmconf_wrap()
{
	return(1);
}
%}

%token TOKJUNK TOKSUBNET TOKDEV TOKSLASH TOKSKIPINTERVALS TOKGRAPHCUTOFF
%token TOKPROMISC TOKOUTPUTCDF TOKRECOVERCDF TOKGRAPH TOKNEWLINE TOKFILTER
%token TOKMETAREFRESH TOKPGSQLCONNECTSTRING TOKSENSORID TOKHTDOCS TOKLOGS
%token TOKPIDFILE TOKTOP TOKMYSQLCONNECTSTRING TOKFTPPORTS TOKHTTPPORTS
%token TOKP2PPORTS TOKMAXIPS
%union
{
	int	number;
	char	*string;
}

%token <string> IPADDR
%token <number> NUMBER
%token <string> STRING
%token <number> STATE
%type <string> string
%%

commands:
	/* EMPTY */
	| commands command
	;

command:
	subnet
	|
	device
	|
	htdocs
	|
	logs
	|
	pidfile
	|
	skip_intervals
	|
	top
	|
	graph_cutoff
	|
	promisc
	|
	output_cdf
	|
	recover_cdf
	|
	graph
	|
	newline
	|
	filter
	|
	meta_refresh
	|
	pgsql_connect_string
	|
	mysql_connect_string
	|
	sensor_id
	|
	http_ports
	|
	ftp_ports
	|
	p2p_ports
	|
	max_ips
	;

ftp_port_list:
	NUMBER
	{	if(ftp_ports >= MAX_FTP_PORTS)
			bmconf_port_error("FTP", MAX_FTP_PORTS);
		ftp_port[ftp_ports++] = $1;
	}
	| NUMBER ftp_port_list
	{	if(ftp_ports >= MAX_FTP_PORTS)
			bmconf_port_error("FTP", MAX_FTP_PORTS);
		ftp_port[ftp_ports++] = $1;
	}
	;

http_port_list:
	NUMBER
	{	if(http_ports >= MAX_HTTP_PORTS)
			bmconf_port_error("HTTP", MAX_HTTP_PORTS);
		http_port[http_ports++] = $1;
	}
	| NUMBER http_port_list
	{	if(http_ports >= MAX_HTTP_PORTS)
			bmconf_port_error("HTTP", MAX_HTTP_PORTS);
		http_port[http_ports++] = $1;
	}
	;

p2p_port_list:
	NUMBER
	{	if(p2p_ports >= MAX_P2P_PORTS)
			bmconf_port_error("P2P", MAX_P2P_PORTS);
		p2p_port[p2p_ports++] = $1;
	}
	| NUMBER p2p_port_list
	{	if(p2p_ports >= MAX_P2P_PORTS)
			bmconf_port_error("P2P", MAX_P2P_PORTS);
		p2p_port[p2p_ports++] = $1;
	}
	;

subnet:
	subneta
	|
	subnetb
	;

newline:
	TOKNEWLINE
	{
		lineno++;
	}
	;

subneta:
	TOKSUBNET IPADDR IPADDR
	{	char *s;
		struct in_addr addr, addr2;

		if(subnet_count >= MAX_SUBNETS) bmconf_subnet_error();
		subnet_table[subnet_count].ip = inet_network($2) &
						inet_network($3);
    		subnet_table[subnet_count].mask = inet_network($3);

		addr.s_addr = ntohl(subnet_table[subnet_count].ip);
		addr2.s_addr = ntohl(subnet_table[subnet_count++].mask);
		s = strdup(inet_ntoa(addr));
		syslog(LOG_INFO,
			"subnet %s netmask %s", s, inet_ntoa(addr2));
		free(s);
	}
	;

subnetb:
	TOKSUBNET IPADDR TOKSLASH NUMBER
	{	char *s;

		UINT subnet, i;
		struct in_addr addr, addr2;

		if(subnet_count >= MAX_SUBNETS) bmconf_subnet_error();
		for(i = 0, subnet = 0; i < $4; i++) {
			subnet >>= 1;
			subnet |= 0x80000000;
		}
 		subnet_table[subnet_count].mask = subnet;
		subnet_table[subnet_count].ip = inet_network($2) & subnet;
		addr.s_addr = ntohl(subnet_table[subnet_count].ip);
		addr2.s_addr = ntohl(subnet_table[subnet_count++].mask);
		s = strdup(inet_ntoa(addr));
		syslog(LOG_INFO,
			"subnet %s netmask %s", s, inet_ntoa(addr2));
		free(s);
	}
	;

string:
	STRING
	{
		$1[strlen($1)-1] = '\0';
		$$ = $1+1;
	}
	;

device:
	TOKDEV string
	{
		config.dev = $2;
	}
	;

htdocs:
	TOKHTDOCS string
	{
		config.htdocs = $2;
	}
	;

logs:
	TOKLOGS string
	{
		config.logs = $2;
	}
	;

pidfile:
	TOKPIDFILE string
	{
		config.pidfile = $2;
	}
	;

filter:
	TOKFILTER string
	{
		config.filter = $2;
	}
	;

meta_refresh:
	TOKMETAREFRESH NUMBER
	{
		config.meta_refresh = $2;
	}
	;

skip_intervals:
	TOKSKIPINTERVALS NUMBER
	{
		config.skip_intervals = $2+1;
	}
	;

top:
	TOKTOP NUMBER
	{	UINT n = $2;

		if(n < MIN_TOP || n > MAX_TOP) {
			fprintf(stderr,
				PROGNAME": value of 'top' must be between %d"
				" and %d in config file on line %d\n",
				MIN_TOP, MAX_TOP, lineno);
			syslog(LOG_ERR, "value of 'top' must be between %d"
				" and %d in config file on line %d", MIN_TOP, MAX_TOP, lineno);
			exit(EXIT_FAILURE);
		}
		config.top = n;
	}
	;

graph_cutoff:
	TOKGRAPHCUTOFF NUMBER
	{
		config.graph_cutoff = $2*1024;
	}
	;

promisc:
	TOKPROMISC STATE
	{
		config.promisc = $2;
	}
	;

output_cdf:
	TOKOUTPUTCDF STATE
	{
		config.output_cdf = $2;
	}
	;

recover_cdf:
	TOKRECOVERCDF STATE
	{
		config.recover_cdf = $2;
	}
	;

graph:
	TOKGRAPH STATE
	{
		config.graph = $2;
	}
	;

pgsql_connect_string:
	TOKPGSQLCONNECTSTRING string
	{
		if(config.db_connect_string != (PCHAR) NULL)
			bmconf_dberror();
		config.db_connect_string = $2;
		config.output_database = DB_PGSQL;
	}
	;

mysql_connect_string:
	TOKMYSQLCONNECTSTRING string
	{
		if(config.db_connect_string != (PCHAR) NULL)
			bmconf_dberror();
		config.db_connect_string = $2;
		config.output_database = DB_MYSQL;
	}
	;

sensor_id:
	TOKSENSORID string
	{
   		config.sensor_id = $2;
	}
	;

ftp_ports:
	TOKFTPPORTS ftp_port_list
	;

http_ports:
	TOKHTTPPORTS http_port_list
	;

p2p_ports:
	TOKP2PPORTS p2p_port_list
	;

max_ips:
	TOKMAXIPS NUMBER
	{
		config.max_ips = $2;
		if(config.max_ips < MIN_MAXIPS || config.max_ips > MAX_MAXIPS) {
			fprintf(stderr,
				PROGNAME": value of 'max_ips' must be between"
				" %d and %d in config file on line %d\n",
				MIN_MAXIPS, MAX_MAXIPS, lineno);
			syslog(LOG_ERR, "value of 'max_ips' must be between"
				" %d and %d in config file on line %d",
				MIN_MAXIPS, MAX_MAXIPS, lineno);
			exit(EXIT_FAILURE);
		}
	}
	;
