/*
 * File: mklegend.c
 *
 * Create the bwmon legend graphic.
 *
 * Bob Eager   May 2016
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <gd.h>
#include <gdfonts.h>

#define	PROGNAME	"mklegend"

#define	XWIDTH		900
#define	YHEIGHT		25
#define	XOFFSET		100
#define	YOFFSET		6
#define	BOXSIZE		12
#define	SPACING		60
#define	XTXTOFFSET	5
#define	YTXTOFFSET	0

#define	BLACK		colours[8]
#define	WHITE		colours[7]

/* Type definitions */

typedef	int		INT, *PINT;
typedef	char		CHAR, *PCHAR;
typedef	unsigned char	UCHAR, *PUCHAR;

/* Tables */

static const PCHAR text[] = {
"FTP", "HTTP", "P2P", "TCP", "UDP", "ICMP", "Other"
};


INT main(INT argc, PCHAR argv[])
{	gdImagePtr im;
	PCHAR file;
	FILE *ofp;
	INT i;
	INT colours[9];

	if(argc != 2) {
		fprintf(stderr, PROGNAME": usage: "PROGNAME" outptfile\n");
		exit(EXIT_FAILURE);
	}
	file = argv[1];

	/* Create an empty image area */

	im = gdImageCreate(XWIDTH, YHEIGHT);

	/* Set up colours */

	colours[0] = gdImageColorAllocate(im, 173, 216, 230);	/* light blue */
	colours[1] = gdImageColorAllocate(im, 0, 0, 255);	/* blue */
	colours[2] = gdImageColorAllocate(im, 255, 0, 255);	/* purple */
	colours[3] = gdImageColorAllocate(im, 0, 255, 0);	/* green */
	colours[4] = gdImageColorAllocate(im, 128, 0, 0);	/* brown */
	colours[5] = gdImageColorAllocate(im, 255, 0, 0);	/* red */
	colours[6] = gdImageColorAllocate(im, 255, 255, 0);	/* yellow */
	colours[7] = gdImageColorAllocate(im, 255, 255, 255);	/* white */
	colours[8] = gdImageColorAllocate(im, 0, 0, 0);		/* black */

	/* Set a white background */

	gdImageFill(im, 0, 0, WHITE);

	/* Draw boxes and fill them, adding text too */

	for(i = 0; i <7; i++) {
		gdImageLine(im,			/* bottom */
			XOFFSET + i*SPACING, YOFFSET,
			XOFFSET + i*SPACING + BOXSIZE, YOFFSET,
			BLACK);
		gdImageLine(im,			/* top */
			XOFFSET + i*SPACING, YOFFSET + BOXSIZE,
			XOFFSET + i*SPACING + BOXSIZE, YOFFSET + BOXSIZE,
			BLACK);
		gdImageLine(im,			/* left */
			XOFFSET + i*SPACING, YOFFSET,
			XOFFSET + i*SPACING, YOFFSET + BOXSIZE,
			BLACK);
		gdImageLine(im,			/* right */
			XOFFSET + i*SPACING + BOXSIZE, YOFFSET,
			XOFFSET + i*SPACING + BOXSIZE, YOFFSET + BOXSIZE,
			BLACK);

		gdImageFill(im,
			XOFFSET + i*SPACING + 1, YOFFSET + 1,
			colours[i]);

		gdImageString(im,
			gdFontSmall,
			XOFFSET + i*SPACING + BOXSIZE + XTXTOFFSET,
			YOFFSET + YTXTOFFSET,
			(PUCHAR) text[i],
			BLACK);

	}

	/* Save the image */

	ofp = fopen(file, "w");
	gdImagePng(im, ofp);
	fclose(ofp);

	exit(EXIT_SUCCESS);
}

/*
 * End of file: mklegend.c
 *
 */

