/*
 * File: data.c
 *
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <unistd.h>
#include <ctype.h>
#include <sys/stat.h>
#include <libxml/tree.h>
#include <libxml/parser.h>

#include "data.h"
#include "prefs.h"

recordstr *rdata;
gpointer data;
GSList *next, *node, *cur;
GSList *list;
guint nLength;
gint records;

gchar *fields[] = {
	"title", "first_name", "last_name", "nickname", "birthday",
	"address_1", "address_2", "city", "county", "country", "post_code",
	"home_phone_1", "home_phone_2",	"home_phone_3", "home_phone_4",
	"work_phone_1", "work_phone_2",	"work_phone_3", "work_phone_4",
	"mobile_phone_1", "mobile_phone_2", "mobile_phone_3", "mobile_phone_4",
	"tag_1", "tag_2", "tag_3", "tag_4",
	"email_1", "email_2", "email_3", "email_4",
	"url_1", "url_2", "url_3", "url_4",
	"notes"
};

recordstr rec_entry;

gpointer fields_ptr[]= {
	rec_entry.title, rec_entry.first_name, rec_entry.last_name,
	rec_entry.nickname,rec_entry.birthday,
	rec_entry.address_1, rec_entry.address_2,
	rec_entry.city, rec_entry.county, rec_entry.country, rec_entry.post_code,
	rec_entry.home_phone_1, rec_entry.home_phone_2,
	rec_entry.home_phone_3, rec_entry.home_phone_4,
	rec_entry.work_phone_1, rec_entry.work_phone_2,
	rec_entry.work_phone_3,	rec_entry.work_phone_4,
	rec_entry.mobile_phone_1, rec_entry.mobile_phone_2,
	rec_entry.mobile_phone_3, rec_entry.mobile_phone_4,
	rec_entry.tag_1, rec_entry.tag_2,
	rec_entry.tag_3, rec_entry.tag_4,
	rec_entry.email_1, rec_entry.email_2,
	rec_entry.email_3, rec_entry.email_4,
	rec_entry.url_1, rec_entry.url_2, rec_entry.url_3, rec_entry.url_4,
	rec_entry.notes
};

gint fields_size[] = {
	size_title, size_name, size_name, size_name, size_birthday,
	size_address, size_address,
	size_city, size_county, size_country, size_post_code,
	size_phone, size_phone,	size_phone, size_phone,
	size_phone, size_phone,	size_phone, size_phone,
	size_phone, size_phone, size_phone, size_phone,
	size_tag, size_tag, size_tag, size_tag,
	size_email, size_email,	size_email, size_email,
	size_url, size_url, size_url, size_url,
	size_notes
};

/*----------------------------------------------------------------------------*/

static gchar* get_data_filename (gchar *config_dir_d, gchar *config_filename_d)
{
static gchar filename[MAX_PATH];
static gchar cfgdir[MAX_PATH];
struct stat cfg;

	strncpy (cfgdir, getenv ("HOME"), MAX_PATH);
	strncat (cfgdir, slash, MAX_PATH);
	strncat (cfgdir, config_dir_d, MAX_PATH);

	if(stat(cfgdir, &cfg) < 0)
		mkdir(cfgdir, S_IRUSR | S_IWUSR | S_IXUSR);

	strncpy (filename, cfgdir, MAX_PATH);
	strncat (filename, slash, MAX_PATH);
	strncat (filename, config_filename_d, MAX_PATH);

	return filename;
}

/*----------------------------------------------------------------------------*/

gint data_init(void)
{
	list = NULL;
	return 0;
}

/*----------------------------------------------------------------------------*/

gint data_close(void)
{

	node = list;

	while (node) {
		free(node->data);
		cur = node;
		node = node->next;
		(void) g_slist_remove (list, cur->data);
	}

	return 0;
}

/*----------------------------------------------------------------------------*/

gint data_get_records(void)
{
gint i;

	for (node = list, i = 0; node; node = node->next, i++);
	return i;

}

/*----------------------------------------------------------------------------*/

gint data_add_record(recordstr *entry)
{
	rdata = calloc(1, sizeof(recordstr));
	g_assert(rdata!=NULL);

	memcpy(rdata, entry, sizeof(recordstr));
	list = g_slist_append (list, rdata);

	return 0;
}

/*----------------------------------------------------------------------------*/

gint data_remove_record(gint k)
{
recordstr *rdata;

	rdata = g_slist_nth_data (list, k);
	list = g_slist_remove (list, rdata);

	return 0;
}

/*----------------------------------------------------------------------------*/

gint data_read(void)
{
xmlDocPtr doc;
xmlNodePtr cur, acur;
xmlChar *prop, *key;
gint i;


	records = 0;

	if((doc = xmlParseFile(get_data_filename(config_dir, DATAFILE)))) {

		if(!(cur = xmlDocGetRootElement(doc))) {
			g_print("WARNING: datafile is empty.\n");
		}

		if(!xmlStrcmp(cur->name, (const xmlChar *) "data")) {

			prop = xmlGetProp(cur, (const xmlChar *) "records");
			if(prop) records = atoi((const char *) prop);

			cur = cur->xmlChildrenNode;
			while (cur != NULL) {

				if(!xmlStrcmp(cur->name, (const xmlChar *) "record")) {

				    memset(&rec_entry, 0, sizeof(recordstr));

					acur = cur->xmlChildrenNode;
					while (acur != NULL) {

						for(i=0; i < nfields; i++) {
							if(!xmlStrcmp(acur->name, (const xmlChar *) fields[i])) {
								key = xmlNodeListGetString(doc, acur->xmlChildrenNode, 1);

								if(key!=NULL) {

									if(i==FIRST_NAME || i==LAST_NAME)
										key[0] = toupper(key[0]);

									strncpy(fields_ptr[i], (const char *) key, fields_size[i]-1);
									strcat(fields_ptr[i], "\0");
								}
							}
						}

						acur = acur->next;
					}

					data_add_record(&rec_entry);
				}

				cur = cur->next;
			}
		}
	}

	return records;
}

/*----------------------------------------------------------------------------*/

gint data_write(void)
{
xmlDocPtr doc;
xmlNodePtr record_node;
gchar c[10];
gint i, j;


	doc = xmlNewDoc((const xmlChar *) "1.0");
	doc->xmlRootNode = xmlNewDocNode(doc, NULL, (const xmlChar *) "data", NULL);

	i = 0;
	node = list;

	while (node) {

		xmlAddChild(doc->xmlRootNode, xmlNewText((const xmlChar *) "\n"));
		record_node = xmlNewChild(doc->xmlRootNode, NULL, (const xmlChar *) "record", NULL);
		xmlAddChild(record_node, xmlNewText((const xmlChar *) "\n"));

		rdata = node->data;
		memcpy(&rec_entry, rdata, sizeof(recordstr));

		for(j=0; j < nfields; j++)
			if(strlen(fields_ptr[j])) {
				xmlAddChild(record_node, xmlNewText((const xmlChar *) "\t"));
				xmlNewTextChild(record_node, NULL, (const xmlChar *) fields[j], fields_ptr[j]);
				xmlAddChild(record_node, xmlNewText((const xmlChar *) "\n"));
			}

			i++;
			node = node->next;
	}

	snprintf(c, 10, "%d", i);
	xmlSetProp(doc->xmlRootNode, (const xmlChar *) "records", (const xmlChar *) c);
	xmlAddChild(doc->xmlRootNode, xmlNewText((const xmlChar *) "\n"));

	xmlSaveFile(get_data_filename(config_dir, DATAFILE), doc);
	xmlFreeDoc(doc);

	return 0;
}

/*----------------------------------------------------------------------------*/

gint find_record(gchar *f, gchar *l)
{
GSList *node;
recordstr *rdata;
gint i, p, s1, s2;

	p = -1;
		
	i = s1 = s2 = 0;

	if(f) s1 = strlen(f);
	if(l) s2 = strlen(l);

	node = list;

	while(node) {

		rdata = node->data;

		if(s1 && s2 && rdata && !strcmp (f, rdata->first_name) && !strcmp (l, rdata->last_name))
			p = i;

			else if(s1 && !s2 && rdata && !strcmp (f, rdata->first_name))
				p = i;

				else if(!s1 && s2 && rdata && !strcmp (l, rdata->last_name))
					p = i;

		i++;
		node = node->next;

	}

	return p;
}

/*------------------------------------------------------------------------------*/

void data_print_csv_entry(FILE *filehandle, recordstr *rdata)
{
gchar a, *buffer;
gchar tmp_buffer_1[size_notes], tmp_buffer_2[size_notes];
gint i, j, k, l, m, e;

	memcpy(&rec_entry, rdata, sizeof(recordstr));

	for(k=0; k < nfields-1; k++) {

		if(k < 32)
			e = (config.selected_fields_1 >> k) & 1;
		else
			e = (config.selected_fields_2 >> (k-32)) & 1;

		if(e) {

			buffer = (gchar *)fields_ptr[k];
			l = strlen(buffer);

			if(l) {

				/* 1 */

				for(i=j=0;i<l;i++)
					if(buffer[i]=='"') j = 1;

				m = i = 0;

				if(j) tmp_buffer_1[m++] = '"';

				do {
					a = buffer[i++];
					if(a=='"') tmp_buffer_1[m++] = '"';
					tmp_buffer_1[m++] = a;
				} while (a!='\0');

				if(j) {
					tmp_buffer_1[m-1] = '"';
					tmp_buffer_1[m] = '\0';
				}

				/* 2 */

				l = strlen(tmp_buffer_1);

				for(i=j=0;i<l;i++)
					if(tmp_buffer_1[i]==',') j = 1;

				m = i = 0;

				if(j) tmp_buffer_2[m++] = '"';

				do {
					a = tmp_buffer_1[i++];
					tmp_buffer_2[m++] = a;
				} while (a!='\0');

				if(j) {
					tmp_buffer_2[m-1] = '"';
					tmp_buffer_2[m] = '\0';
				}
			
			    fprintf(filehandle, "%s", tmp_buffer_2);

			}

			if(k != nfields-1) fprintf(filehandle, ",");
		}
	}
	fprintf(filehandle, "\n");
}

/*------------------------------------------------------------------------------*/

const static char special[] = {
'\"',
'&',
'<',
'>',
'`',
};

const static char *special_str[] = {
"&quot;",
"&amp;",
"&lt;",
"&gt;",
"&acute;"
};

void data_print_html_entry(FILE *filehandle, recordstr *rdata)
{
gchar a, tmp_buffer[size_notes], *buffer;
gint i, j, k, l, n, e;
gint repl;

	memcpy(&rec_entry, rdata, sizeof(recordstr));

	for(k=0; k < nfields-1; k++) {

		if(k < 32)
			e = (config.selected_fields_1 >> k) & 1;
		else
			e = (config.selected_fields_2 >> (k-32)) & 1;

		if(e) {

			fprintf(filehandle, "\t<td>");

			buffer = (gchar *)fields_ptr[k];
			l = strlen(buffer);

			if(l) {

				for(i=j=0;i<l;i++) {

					a = buffer[i];

					repl = 0;
					for(n = 0; n < sizeof(special); n++) {
						if(a == special[n]) {
							repl = 1;
							tmp_buffer[j] = '\0';
							strcat(tmp_buffer, special_str[n]);
							j += strlen(special_str[n]);
						}
					}
					if(repl == 0) tmp_buffer[j++] = a;
				}

				tmp_buffer[j] = '\0';

				switch (k)
				{
					case EMAIL_1:
					case EMAIL_2:
					case EMAIL_3:
					case EMAIL_4:
						fprintf(filehandle, "<a href=\"mailto:%s\">%s</a>", tmp_buffer, tmp_buffer);
						break;
					case URL_1:
					case URL_2:
					case URL_3:
					case URL_4:
						fprintf(filehandle, "<a href=\"%s\">%s</a>", tmp_buffer, tmp_buffer);
						break;
					default:
						fprintf(filehandle, "%s", tmp_buffer);
				}
			} else
				fprintf(filehandle, "&nbsp;");

			fprintf(filehandle, "</td>\n");

		}
	}

}

/*
 * End of file: data.c
 *
 */
