/*
 * File: gui.h
 *
 */

#include <stdio.h>

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>

#define	WELCOME_TEXT	"Welcome to Dlume"
#define	TMPBUF_SIZE	1024

typedef enum {
	EMAIL = 0,
	URL,
} link_type;

void		gui_create_window		(void);
void		gui_show_status			(gchar *message);
void		gui_create_prefs_window		(void);
void		gui_set_button_bg_color		(GtkWidget *widget, gchar *icolor);
void		gui_display_entry		(gchar *first_name, gchar *last_name);
gint		gui_display_records_list	(void);
gint		gui_update_records_list		(gchar *value);
gchar*		gui_get_column_content 		(gint row, gint column);
GtkWidget*	gui_stock_button		(const gchar *bstock);
void		gui_list_set_row		(gint row);
gint		gui_list_get_row		(void);

extern		GtkWidget			*main_window;
extern		GtkWidget			*toolbar;
extern		GtkTextBuffer			*entry_textinfo;
extern		GtkWidget			*text_sheet;
extern		GtkWidget			*find_entry;
extern		gchar				current_fn[], current_ln[];
extern		GtkTreeViewColumn		*column_fn, *column_ln;
extern		GtkTreeModel 			*model;
extern		gchar				*icon_xpm[];

/*
 * End of file: gui.h
 *
 */
