/*
 * File: main.c
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <glib.h>
#include <string.h>

#include "gui.h"
#include "data.h"
#include "prefs.h"

/*
 * History:
 *	1.0	- initial revived version.
 *	1.1	- added Title field
 *		- implemented quoted characters in HTML export
 *		- changed data save to use XmlNewTextChild so that embedded
 *		  ampersands are handled correctly
 *		- increased size of name fields
 *
 */

int main(int argc, char *argv[])
{
	read_config ();

	data_init ();
	data_read ();

	config.run_counter++;

	gtk_init (&argc, &argv);
	gui_create_window ();

	gtk_main ();

	data_write();
	data_close();

	write_config ();

	exit(EXIT_SUCCESS);
}

/*
 * End of file: main.c
 *
 */
