/*
 * File: actions.c
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <sys/types.h>
#include <unistd.h>

#include "gui.h"
#include "data.h"
#include "prefs.h"
#include "actions.h"

static gchar command[MAX_PATH];

/*----------------------------------------------------------------------*/

void execute_command(gchar *command)
{
gchar *cmdline[4];
pid_t pid;

	pid = fork();

	if (pid == 0) {

		cmdline[0] = "sh";
		cmdline[1] = "-c";
		cmdline[2] = command;
		cmdline[3] = 0;
		execvp("/bin/sh", cmdline);
		_exit(1);

	}
}

/*----------------------------------------------------------------------*/

gint action_send_email(gchar *email)
{
	sprintf(command, config.email_client, email);
	execute_command(command);

	return 0;
}

/*----------------------------------------------------------------------*/

gint action_launch_website(gchar *url)
{
	sprintf(command, config.web_browser, url);
	execute_command(command);

	return 0;
}

/*
 * End of file: actions.c
 *
 */


