/*
 * File: data.h
 *
 */

#define		DATAFILE		"dlume-data.xml"

#define		size_title			20
#define		size_name			50
#define		size_address			50
#define		size_city			25
#define		size_country			25
#define		size_county			25
#define		size_post_code			15
#define		size_phone			45
#define		size_tag			25
#define		size_email			40
#define		size_url			50
#define		size_birthday			25
#define		size_notes			4096

#define		nfields				36		/* number of fields */

typedef struct
{
	gchar		title[size_title];
	gchar		first_name[size_name];
	gchar		last_name[size_name];
	gchar		nickname[size_name];
	gchar		birthday[size_birthday];
	gchar		address_1[size_address];
	gchar		address_2[size_address];
	gchar		post_code[size_post_code];
	gchar		city[size_city];
	gchar		county[size_county];
	gchar		country[size_country];

	gchar		home_phone_1[size_phone];
	gchar		home_phone_2[size_phone];
	gchar		home_phone_3[size_phone];
	gchar		home_phone_4[size_phone];

	gchar		work_phone_1[size_phone];
	gchar		work_phone_2[size_phone];
	gchar		work_phone_3[size_phone];
	gchar		work_phone_4[size_phone];

	gchar		mobile_phone_1[size_phone];
	gchar		mobile_phone_2[size_phone];
	gchar		mobile_phone_3[size_phone];
	gchar		mobile_phone_4[size_phone];

	gchar		tag_1[size_tag];
	gchar		tag_2[size_tag];
	gchar		tag_3[size_tag];
	gchar		tag_4[size_tag];

	gchar		email_1[size_email];
	gchar		email_2[size_email];
	gchar		email_3[size_email];
	gchar		email_4[size_email];

	gchar		url_1[size_url];
	gchar		url_2[size_url];
	gchar		url_3[size_url];
	gchar		url_4[size_url];

	gchar		notes[size_notes];

} recordstr;


gint data_add_record		(recordstr *entry);
gint data_show			(void);
gint data_init			(void);
gint data_close			(void);
gint data_write			(void);
gint data_read			(void);
gint fill_record		(recordstr *entry);
gint find_record		(gchar *f, gchar *l);
gint data_remove_record		(gint k);
gint data_get_records		(void);
void data_print_csv_entry	(FILE *filehandle, recordstr *rdata);
void data_print_html_entry	(FILE *filehandle, recordstr *rdata);

extern gint records;
extern GSList *list;
extern gint fields_size[];

enum {
	TITLE = 0,
	FIRST_NAME,
	LAST_NAME,
	NICKNAME,
	BIRTHDAY,
	ADDRESS1,
	ADDRESS2,
	CITY,
	COUNTY,
	COUNTRY,
	POST_CODE,
	HOME_PHONE_1,
	HOME_PHONE_2,
	HOME_PHONE_3,
	HOME_PHONE_4,
	WORK_PHONE_1,
	WORK_PHONE_2,
	WORK_PHONE_3,
	WORK_PHONE_4,
	MOBILE_PHONE_1,
	MOBILE_PHONE_2,
	MOBILE_PHONE_3,
	MOBILE_PHONE_4,
	TAG_1,
	TAG_2,
	TAG_3,
	TAG_4,
	EMAIL_1,
	EMAIL_2,
	EMAIL_3,
	EMAIL_4,
	URL_1,
	URL_2,
	URL_3,
	URL_4,
	NOTES
};

/*
 * End of file: data.h
 *
 */

