/*
 * File: delete.c
 *
 */

#include "gui.h"
#include "data.h"
#include "delete.h"
#include "prefs.h"


/*------------------------------------------------------------------------------*/

void gui_create_delete_window(void)
{
GtkTextIter		a_iter, b_iter;
GtkWidget		*info_dialog;
gint			k, response;
GtkWidget		*hbox;
GtkWidget		*label;
GtkWidget		*stock;


	k = find_record(current_fn, current_ln);

	if (k!=-1) {

		gui_show_status("Deletion is irreversible ...");

		info_dialog = gtk_dialog_new_with_buttons ("Question",
						GTK_WINDOW (main_window),
						GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
						GTK_STOCK_NO,
						GTK_RESPONSE_NO,
						GTK_STOCK_YES,
						GTK_RESPONSE_OK,
						NULL);

		hbox = gtk_hbox_new (FALSE, 8);
		gtk_container_set_border_width (GTK_CONTAINER (hbox), 8);
		gtk_box_pack_start (GTK_BOX (GTK_DIALOG (info_dialog)->vbox), hbox, FALSE, FALSE, 0);

		stock = gtk_image_new_from_stock (GTK_STOCK_DIALOG_QUESTION, GTK_ICON_SIZE_DIALOG);
		gtk_box_pack_start (GTK_BOX (hbox), stock, FALSE, FALSE, 0);

		label = gtk_label_new ("Delete current contact ?");
		gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

		gtk_widget_show_all (hbox);

		response = gtk_dialog_run (GTK_DIALOG (info_dialog));

		if (response == GTK_RESPONSE_OK) {

			k = find_record(current_fn, current_ln);

			if (k!=-1) {

				data_remove_record(k);

				gui_show_status("Contact deleted");

				gtk_text_buffer_get_bounds (entry_textinfo, &a_iter, &b_iter);
				gtk_text_buffer_delete (entry_textinfo, &a_iter, &b_iter);

				gui_display_records_list();
				gui_update_records_list((gchar *)gtk_entry_get_text(GTK_ENTRY(find_entry)));

			}

		}

		gtk_widget_destroy(info_dialog);
		gui_show_status("Idle");

	} else {

		if(data_get_records())
			gui_show_status("Please select contact to delete first");
		else
			gui_show_status("No contacts to delete");

	}

}

/*
 * End of file: delete.c
 *
 */


