/*
 * File: act.c
 *
 * Control program for door lock release.
 *
 * Action module
 *
 * Bob Eager   May 2014
 *
 */

#include "lockctl.h"

/* Action tables */

const	char	lock_bytes[] = { 0xff, 0x01, 0x00 };
const	char	unlock_bytes[] = { 0xff, 0x01, 0x01 };

/*
 * Main action function.
 *
 */

extern BOOL act(PCHAR port, INT relock_interval, ACTION action, BOOL verbose)
{	INT fd, n;
	BOOL rc = TRUE;

	signal(SIGINT, SIG_IGN);
	signal(SIGQUIT, SIG_IGN);
	signal(SIGTERM, SIG_IGN);
	signal(SIGTSTP, SIG_IGN);

	fd = open(port, O_WRONLY);
	if(fd == -1) {
		error("cannot open port %s", port);
		return(FALSE);
	}

	switch(action) {
		case ACT_UNLOCK:
			if(verbose == TRUE) ADVISE("unlocking...\n");
			n = write(fd, &unlock_bytes[0], sizeof(unlock_bytes));
			if(n != sizeof(unlock_bytes)) {
				error("unlock write error");
				rc = FALSE;
				break;
			}
			if(verbose == TRUE) ADVISE("done.\n");
			sleep(relock_interval);
			if(verbose == TRUE) ADVISE("relocking...\n");
			n = write(fd, &lock_bytes[0], sizeof(lock_bytes));
			if(n != sizeof(lock_bytes)) {
				error("relock write error");
				rc = FALSE;
				break;
			}
			if(verbose == TRUE) ADVISE("done.\n");
			break;

		case ACT_LOCK:
			if(verbose == TRUE) ADVISE("locking...\n");
			n = write(fd, &lock_bytes[0], sizeof(lock_bytes));
			if(n != sizeof(lock_bytes)) {
				error("lock write error");
				rc = FALSE;
			}
			if(verbose == TRUE) ADVISE("done.\n");
			break;

		case ACT_NONE:
			error("internal error (bad action)");
			rc = FALSE;
			break;
	}

	(VOID) close(fd);

	return(rc);
}

/*
 * End of file: act.c
 *
 */
