/*
 * File: lockctl.h
 *
 * Control program for door lock release.
 *
 * Header file
 *
 * Bob Eager   May 2014
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <libgen.h>
#include <unistd.h>
#include <limits.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <signal.h>
#include "typedefs.h"

#define	VERSION			1	/* Major version number */
#define	EDIT			0	/* Edit number within major version */

/* Macros */

#define	ADVISE(x) \
	fprintf(stderr, x);

/* Constants */

/* Relock delay values (in seconds) */

#define	MIN_RELOCK		2	/* Minimum relock delay */
#define	MAX_RELOCK		60	/* Maximum relock delay */
#define	DEFAULT_RELOCK		10	/* Default relock delay */

/* Type definitions */

typedef	enum { ACT_LOCK, ACT_UNLOCK, ACT_NONE }	ACTION;

/* External references */

extern	BOOL	act(PCHAR port, INT relock_interval, ACTION action, BOOL verbose);
extern	VOID	error(PCHAR mes, ...);

/*
 * End of file: lockctl.h
 *
 */
