/*
 * File: confcmds.h
 *
 * Weather utility
 *
 * Configuration command codes and table
 *
 * Bob Eager   May 2017
 *
 */

/* Internal command codes */

#define	CMD_URL			1
#define	CMD_APPID		2
#define	CMD_LOCATION		3
#define	CMD_UNITS		4
#define	CMD_BAD			5

static	struct {
	PCHAR	cmdname;		/* Command name */
	INT	cmdcode;		/* Command code */
} cmdtab[] = {
	{ "URL",		CMD_URL },
	{ "APPID",		CMD_APPID },
	{ "LOCATION",		CMD_LOCATION },
	{ "UNITS",		CMD_UNITS },
	{ "",			CMD_BAD }	/* End of table marker */
};

/*
 * End of file: confcmds.h
 *
 */
