/*
 * File: massage.c
 *
 * Weather utility
 *
 * Data massaging
 *
 * Bob Eager   May 2017
 *
 */

#include "owrep.h"


/*
 * Massage the data in 'weather'; principally, this is just adjusting
 * units, etc.
 *
 *	Inputs:
 *		config	pointer to configuration structure
 *		weather	pointer to weather structure for input and output
 *
 *	Outputs:
 *		weather structure modified as required
 *
 */

VOID massage_weather(PCONFIG config, PWEATHER weather)
{	switch(config->units) {
		case IMPERIAL:
			strcpy(&weather->temp_units[0], "Fahrenheit");
			if(strcasecmp(&weather->pressure_units[0], "hPa") == 0)
				strcpy(&weather->pressure_units[0], "mbar");
			strcpy(&weather->wind_speed_units[0], "mph");
			weather->visibility = weather->visibility*3937 / 3600;
			strcpy(&weather->visibility_units[0], "yards");
			if(weather->precipitation != -1.0)
				weather->precipitation = weather->precipitation/25.4;
			strcpy(&weather->precipitation_units[0], "in");
			break;

		case METRIC:
			strcpy(&weather->temp_units[0], "Celsius");
			if(strcasecmp(&weather->pressure_units[0], "hPa") == 0)
				strcpy(&weather->pressure_units[0], "mbar");
			weather->wind_speed = weather->wind_speed*3600 / 1000;
			if(weather->wind_speed_gusts != 0)
				weather->wind_speed_gusts =
					weather->wind_speed_gusts*3600 / 1000;
			strcpy(&weather->wind_speed_units[0], "km/h");
			strcpy(&weather->visibility_units[0], "metres");
			strcpy(&weather->precipitation_units[0], "mm");
			break;

		default:
			error(" bad units type %d in massage_weather",
				config->units);
			exit(EXIT_FAILURE);
	}

	if(weather->coord_lon >= 0) {
		strcpy(weather->coord_lon_direction, "E");
	} else {
		weather->coord_lon = -weather->coord_lon;
		strcpy(weather->coord_lon_direction, "W");
	}
	if(weather->coord_lat >= 0) {
		strcpy(weather->coord_lat_direction, "N");
	} else {
		weather->coord_lat = -weather->coord_lat;
		strcpy(weather->coord_lat_direction, "S");
	}
}

/*
 * End of file: massage.c
 *
 */
