/*
 * File owrep.h
 *
 * Weather utility
 *
 * Header file
 *
 * Bob Eager   May 2017
 *
 */

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <stdlib.h>
#include <limits.h>

#include <sys/socket.h>
#include <sys/time.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/nameser.h>
#include <arpa/inet.h>
#include <resolv.h>
#include <unistd.h>

#include "typedefs.h"

#define	VERSION			1	/* Major version number */
#define	EDIT			1	/* Edit number within major version */

#define	MAXLINE			250	/* Size of line buffer */
#define	MAXLOG			200	/* Size of log buffer */

#define	HTTP_SCHEME		"http://"
#define	HTTPSERVICE		"http"	/* Name of HTTP service */
#define	TCP			"tcp"	/* TCP protocol */

typedef struct _CONFIG {		/* Configuration information */
BOOL		compressed;		/* Compressed output */
BOOL		debug;			/* Debug flag */
CHAR		delim;			/* Output delimiter */
INT		location;		/* Location code */
UNITS		units;			/* Units choice */
PCHAR		appid;			/* Application ID string */
PCHAR		url;			/* URL for lookup service */
} CONFIG, *PCONFIG;

typedef struct _WEATHER {		/* Weather information */
BOOL		valid;			/* Indicates valid extraction */
PCONFIG		config;			/* Config structure */
CHAR		cityname[100];		/* City name as string */
CHAR		country[10];		/* Country name as string */
FLOAT		coord_lon;		/* Longitude */
CHAR		coord_lon_direction[2];	/* Longitude direction */
FLOAT		coord_lat;		/* Latitude */
CHAR		coord_lat_direction[2];	/* Latitude direction */
CHAR		sun_rise[30];		/* Date and time of sunrise */
CHAR		sun_set[30];		/* Date and time of sunset */
INT		temp_now;		/* Current temperature */
INT		temp_min;		/* Min current temperature */
INT		temp_max;		/* Max current temperature */
CHAR		temp_units[20];		/* Temperature units */
INT		humidity;		/* Humidity */
CHAR		humidity_units[20];	/* Humidity units */
INT		pressure;		/* Pressure */
CHAR		pressure_units[20];	/* Pressure units */
FLOAT		wind_speed;		/* Wind speed */
CHAR		wind_speed_units[20];	/* Filled in locally */
FLOAT		wind_speed_gusts;	/* Gust speed */
CHAR		wind_speed_name[50];	/* Wind speed description */
INT		wind_direction;		/* Wind direction (degrees) */
CHAR		wind_direction_code[10];/* Wind direction (short code) */
CHAR		wind_direction_name[50];/* Wind direction description */
INT		clouds;			/* Cloud cover (%) */
CHAR		clouds_name[30];	/* Cloud cover description */
INT		visibility;		/* Visibility */
CHAR		visibility_units[20];	/* Filled in locally */
FLOAT		precipitation;		/* Precipitation */
CHAR		precipitation_mode[30];	/* Precipitation type */
CHAR		precipitation_units[20];/* Filled in manually */
CHAR		lastupdate[30];		/* Date and time of last update */
} WEATHER, *PWEATHER;

/* External references */

extern	VOID	dolog(PCHAR, ...);
extern	VOID	error(PCHAR, ...);
extern	VOID	extract_weather(PCHAR, INT, PCONFIG, PWEATHER);
extern	PCHAR	get_weather(PCONFIG, PINT);
extern	VOID	massage_weather(PCONFIG, PWEATHER);
extern	VOID	output_weather(PCONFIG, PWEATHER);
extern	INT	read_config(PCHAR, PCONFIG);
extern	VOID 	strlwr(PCHAR);
extern	PVOID	xmalloc(size_t);

/*
 * End of file: owrep.h
 *
 */
