/*
 * File: typedefs.h
 *
 * General type definitions
 *
 * Bob Eager   May 2017
 *
 */

#ifndef	TYPEDEFS_H
#define	TYPEDEFS_H
typedef	void			VOID,*PVOID;
typedef	int			INT,*PINT;
typedef unsigned int		UINT,*PUINT;
typedef	long			LONG,*PLONG;
typedef	unsigned long		ULONG,*PULONG;
typedef	short			SHORT,*PSHORT;
typedef	unsigned short		USHORT,*PUSHORT;
typedef	char			CHAR,*PCHAR;
typedef	unsigned char		UCHAR,*PUCHAR;
typedef	int			BOOL,*PBOOL;
typedef	float			FLOAT,*PFLOAT;

typedef	enum _UNITS { UNITS_NONE=0, IMPERIAL, METRIC } UNITS, *PUNITS;

typedef	struct hostent		HOST, *PHOST;		/* Host structure */
typedef	struct servent		SERV, *PSERV;		/* Service structure */
typedef struct in_addr		INADDR, *PINADDR;	/* Internet address */
typedef	struct sockaddr		SOCKG, *PSOCKG;		/* Generic structure */
typedef	struct sockaddr_in	SOCK, *PSOCK;		/* Internet structure */

#define	FALSE			0
#define	TRUE			1
#endif

/*
 * End of file: typedefs.h
 *
 */
