/*
 * File: confcmds.h
 *
 * POP3D daemon for distributing mail on Tavi network; to be invoked only
 * by inetd.
 *
 * Configuration command codes and table.
 *
 * Bob Eager   May 2016
 *
 */

/* Internal command codes */

#define	CMD_LOGGING		1
#define	CMD_LOGFILE		2
#define	CMD_MAILBASE		3
#define	CMD_SPLITSUBJ		4
#define	CMD_USER		5
#define	CMD_GROUP		6
#define	CMD_BAD			7

static	struct {
	CHAR	*cmdname;		/* Command name */
	INT	cmdcode;		/* Command code */
} cmdtab[] = {
	{ "LOGGING",		CMD_LOGGING },
	{ "LOGFILE",		CMD_LOGFILE },
	{ "MAILBASE",		CMD_MAILBASE },
	{ "SPLIT_SUBJECT",	CMD_SPLITSUBJ },
	{ "USER",		CMD_USER },
	{ "GROUP",		CMD_GROUP },
	{ "",			CMD_BAD }	/* End of table marker */
};

/*
 * End of file: confcmds.h
 *
 */

