/*
 * File: log.h
 *
 * General logging and tracing routines; header file.
 *
 * Bob Eager   May 2016
 *
 */

#include "typedefs.h"

/* Tunable constants */

#ifdef	DEBUG
#define	MAXLOG			500	/* Maximum length of a logfile line */
#else
#define	MAXLOG			200	/* Maximum length of a logfile line */
#endif

/* Error codes */

#define	LOGERR_OK		0	/* Log successfully opened */
#define	LOGERR_OPENFAIL		1	/* Failed to open log */
#define	LOGERR_LOGTYPE		2	/* Unrecognised logging type */

/* Type definitions */

typedef	enum	{ LOGGING_UNSET, LOGGING_FILE, LOGGING_SYSLOG }
				LOGTYPE;

/* External references */

extern	VOID	close_log(VOID);
extern	VOID	dolog(UINT, PCHAR);
extern	INT	open_log(UINT, PCHAR, PCHAR, PCHAR);
#ifdef	DEBUG
extern	VOID	trace(PCHAR, ...);
#endif

/*
 * End of file: log.h
 *
 */

