/*
 * File: pop3d.h
 *
 * POP3 daemon for distributing mail on Tavi network; normally invoked
 * by inetd.
 *
 * Header file
 *
 * Bob Eager   May 2016
 *
 */

#define	VERSION			5	/* Major version number */
#define	EDIT			5	/* Edit number within major version */

#define	DEFAULT_CONFIG		"/usr/local/etc/pop3d.conf"
#define	DEFAULT_LOGFILE		"/var/log/pop3d.log"
#define	DEFAULT_MAILBASE	"/var/mail"

#include <syslog.h>

#include "typedefs.h"
#include "log.h"

/* Structure definitions */

typedef struct _CONFIG {                /* Configuration information */
LOGTYPE		log_type;		/* Type of logging */
PCHAR		log_file;		/* Logfile name */
PCHAR		mail_base;		/* Maildrop base directory */
BOOL		split_subject;		/* Whether to split subject line */
PCHAR		user;			/* User to run as */
PCHAR		group;			/* Group to run as */
} CONFIG, *PCONFIG;

/* External references */

extern	VOID	error(PCHAR, ...);
extern  INT     read_config(PCHAR, PCONFIG);
extern	BOOL	server(INT, PCHAR, PCHAR, PCONFIG);
extern	VOID	strlwr(PCHAR);
extern	PVOID	xmalloc(size_t);

/*
 * End of file: pop3d.h
 *
 */
