/*
 * File: auth.c
 *
 * General user authorisation routines
 *
 * Bob Eager   May 2016
 *
 */

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "auth.h"
#ifdef	DEBUG
#include "log.h"
#endif

#define	AUTHFILE	".auth"
#define	MAXLINE		100

/*
 * Check user authorisation.
 *
 * Returns:
 *	AUTH_OK		user authorised OK
 *	AUTH_FAILURE	authorisation failure
 *
 */

INT authorise(PCHAR username, PCHAR password, PCHAR mailbase)
{	INT res;
	FILE *fp;
	CHAR s[MAXLINE+1];
	PCHAR p;
	PCHAR afile = (PCHAR) malloc(strlen(mailbase) +
		      1 +			/* possible "/" */
		      strlen(username) +
		      1 +			/* "/" */
		      strlen(AUTHFILE) +
		      1);			/* '\0' */

	if(afile == (PCHAR) NULL) return(AUTH_FAILURE);

	strcpy(afile, mailbase);
	if(afile[strlen(afile)-1] != '/') strcat(afile, "/");
	strcat(afile, username);
	strcat(afile, "/");
	strcat(afile, AUTHFILE);

#ifdef	DEBUG
	trace("auth file = |%s|", afile);
#endif

	fp = fopen(afile, "r");
	if(fp == (FILE *) NULL) {
#ifdef	DEBUG
	trace("auth file not found");
#endif
		free(afile);
		return(AUTH_FAILURE);
	}

	if(fgets(s, MAXLINE, fp) == (PCHAR) NULL) s[0] = '\0';
	p = strtok(s, " \t\n");	

	res = AUTH_FAILURE;
#ifdef	DEBUG
	trace("auth: given password = |%s|, auth file password = |%s|",
		password, p == (PCHAR) NULL ? "(null)" : p);
#endif
	if(p != (PCHAR) NULL &&
	   strcasecmp(p, (PCHAR) password) == 0)
		res = AUTH_OK;

	fclose(fp);
	free(afile);

#ifdef	DEBUG
	trace("auth result = %s", res == AUTH_OK ? "OK" : "failure");
#endif
	return(res);
}

/*
 * End of file: auth.c
 *
 */
